extends Node

# This class is for animation diffrent ui nodes such as Buttons (press animation,
# Windows Open / close animations
var _tween : Tween

func btn_press(target : Control) -> void:
	if _tween:
		if _tween.is_active():
			return
	
	_tween = Tween.new()
	
	_set_target_pivot(target) # set pivot to center
	
	# Create a tween node
	_tween.connect("tween_all_completed",self,"_on_press_down",[_tween,target],
		CONNECT_ONESHOT)
	add_child(_tween)
	
	# animate control 
	var tween_from : Vector2 = target.get_scale()
	var tween_to := tween_from - Vector2(0.15,0.15)
	_tween.interpolate_property(
		target,
		"rect_scale",
		tween_from,
		tween_to,
		0.1,
		Tween.TRANS_EXPO,
		Tween.EASE_IN)
	_tween.start()


# Set control node pivot offset to center
func _set_target_pivot(target : Control) -> void:
	var rect_size := target.get_size()
	var new_pivot := Vector2(rect_size.x / 2 , rect_size.y / 2)
	target.set_pivot_offset(new_pivot)


func _on_press_down(tween : Tween , target : Control) -> void:
	tween.connect("tween_all_completed",self,"_on_press_finish",[tween],
	CONNECT_ONESHOT)
# animate control 
	var tween_from : Vector2 = target.get_scale()
	var tween_to := tween_from + Vector2(0.15,0.15)
	tween.interpolate_property(
		target,
		"rect_scale",
		tween_from,
		tween_to,
		0.1,
		Tween.TRANS_EXPO,
		Tween.EASE_OUT)
	tween.start()



func _on_press_finish(tween : Tween) -> void:
	_tween.queue_free()
	_tween = null
